/*____________________________________________________________________________
		Copyright (C) 2000 Network Associates, Inc.
        All rights reserved.

        $Id: CCursor.cpp,v 1.2 2000/01/07 07:46:57 nryan Exp $
____________________________________________________________________________*/

#include "pgpClassesConfig.h"

#include "UMath.h"
#include "CCursor.h"

_USING_PGP

// Class CCursor member functions

CCursor::CCursor(HCURSOR cursor) : 
	mWeCreated(FALSE), mCursor(cursor), mOldCursor(NULL)
{
}

CCursor::CCursor(HINSTANCE instance, LPCTSTR cursorName, PGPBoolean shared) : 
	mWeCreated(FALSE), mCursor(NULL), mOldCursor(NULL)
{
	Load(instance, cursorName, shared);
}

CCursor::~CCursor()
{
	try
	{
		Clear();
	}
	catch (CComboError&) { }
}

void 
CCursor::Load(HINSTANCE instance, LPCTSTR cursorName, PGPBoolean shared)
{
	mCursor = static_cast<HCURSOR>(
		LoadImage(instance, cursorName, IMAGE_CURSOR, 0, 0, 
		shared ? LR_SHARED : 0));

	if (IsNull(mCursor))
		THROW_ERRORS(kPGPError_Win32ResourceOpFailed, GetLastError());

	mWeCreated = TRUE;
}

void 
CCursor::LoadCurrentCursor()
{
	mCursor = ::GetCursor();
}

void 
CCursor::SetCursor()
{
	mOldCursor = ::SetCursor(mCursor);
}

void 
CCursor::RestoreCursor()
{
	::SetCursor(mOldCursor);
	mOldCursor = NULL;
}

PGPBoolean 
CCursor::GetCursorPos(PPOINT pPoint)
{
	return ::GetCursorPos(pPoint);
}

PGPBoolean 
CCursor::SetCursorPos(PGPInt32 x, PGPInt32 y)
{
	return ::SetCursorPos(x, y);
}

PGPInt32 
CCursor::ShowCursor(PGPBoolean show)
{
	return ShowCursor(show);
}

void 
CCursor::Clear()
{
	if (mWeCreated)
		DestroyCursor(mCursor);

	mCursor = NULL;
	mOldCursor = NULL;
}
